<?php

/**
 * This is the model class for table "FormularzDane".
 *
 * The followings are the available columns in table 'FormularzDane':
 * @property double $id
 * @property double $idPola
 * @property double $idFormularzaUzytkownika
 * @property string $wartosc
 */
class FormularzDane extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FormularzDane the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'FormularzDane';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('id, idPola, idFormularzaUzytkownika', 'numerical'),
			array('wartosc', 'length', 'max'=>500),

			array('id, idPola, idFormularzaUzytkownika, wartosc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('FormularzDane', 'id'),
			'idPola'=>Yii::t('FormularzDane', 'idPola'),
			'idFormularzaUzytkownika'=>Yii::t('FormularzDane', 'idFormularzaUzytkownika'),
			'wartosc'=>Yii::t('FormularzDane', 'wartosc'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idPola', $this->idPola);
		$criteria->compare('idFormularzaUzytkownika', $this->idFormularzaUzytkownika);
		$criteria->compare('wartosc', $this->wartosc, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}